/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.LsBoxInfo;
import ibm.nways.lspeed.LsModuleView;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class LsGraphic {
    private static final int RASID = 19;
    private static final int RASSUBID = 11;
    private static ResourceBundle lspeedBundle;
    protected static final String PropertiesFile = "properties/lspeed.txt";
    protected static final String layoutKey = "layout.scheme";
    protected static final String fractKey = "layout.fractions";
    protected static final int IconXpos = 32;
    protected static final int SlotXpos = 0;
    private JdmBrowser lsBrowser;
    private LsBoxInfo boxInfo;
    private GenModel lsModule_model;
    private GenModel lsAtmModule_model;
    private boolean completePicture;

    public LsGraphic(JdmBrowser jdmBrowser, LsBoxInfo lsBoxInfo, boolean bl) {
        ModelInfo modelInfo;
        int n;
        Vector vector;
        if (RAS.isEnabled(19, 11)) {
            RAS.trace(19, 11, this, "LsGraphic", "constructor");
        }
        lspeedBundle = ResourceBundle.getBundle("ibm.nways.lspeed.LsGeneralResources");
        this.lsBrowser = jdmBrowser;
        this.boxInfo = lsBoxInfo;
        this.lsModule_model = this.boxInfo.getLsModel("LsModule");
        this.lsAtmModule_model = this.boxInfo.getLsModel("LsAtmModule");
        try {
            if (this.lsModule_model != null) {
                vector = this.lsModule_model.getRestOfInfo("ModuleInfo", "default", null, null);
                n = 0;
                while (n < vector.size()) {
                    modelInfo = (ModelInfo)vector.elementAt(n);
                    modelInfo.flagAsMonitored();
                    this.lsModule_model.setInfo("ModuleInfo", modelInfo);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 11)) {
                RAS.trace(19, 11, this, "LsGraphic", "Failed to get LsModuleInfo");
            }
            RAS.logException(19, 11, this, "LsGraphic", exception);
        }
        try {
            if (this.lsAtmModule_model != null) {
                vector = this.lsAtmModule_model.getRestOfInfo("ModuleInfo", "default", null, null);
                n = 0;
                while (n < vector.size()) {
                    modelInfo = (ModelInfo)vector.elementAt(n);
                    modelInfo.flagAsMonitored();
                    this.lsAtmModule_model.setInfo("ModuleInfo", modelInfo);
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 11)) {
                RAS.trace(19, 11, this, "LsGraphic", "Failed to get LsModuleInfo");
            }
            RAS.logException(19, 11, this, "LsGraphic", exception);
        }
    }

    protected GraphicPanel getGraphicPanel() {
        String string;
        int n;
        Object object;
        Object object2;
        int n2;
        Properties properties;
        Serializable serializable;
        new Panel();
        int n3 = 0;
        int n4 = 75;
        if (RAS.isEnabled(19, 11)) {
            RAS.trace(19, 11, this, "getGraphicPanel", "entry");
        }
        try {
            serializable = new URL(this.lsBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 11)) {
                RAS.trace(19, 11, this, "getGraphicPanel", "Error getting Lspeed Properties: " + exception.getMessage());
            }
            properties = null;
            RAS.logException(19, 11, this, "getGraphicPanel", exception);
        }
        JdmLayout jdmLayout = (JdmLayout)this.lsBrowser.getLayout();
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (RAS.isEnabled(19, 11)) {
                RAS.trace(19, 11, this, "getGraphicPanel", "The layout scheme prpt = " + serializable);
            }
            n2 = (Integer)serializable;
            jdmLayout.setScheme(n2);
            object2 = (String)((Hashtable)properties).get(fractKey);
            object = new StringTokenizer((String)object2);
            float[] fArray = new float[((StringTokenizer)object).countTokens()];
            n = 1;
            int n5 = 0;
            while (n5 < fArray.length && ((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                try {
                    fArray[n5] = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (RAS.isEnabled(19, 11)) {
                        RAS.trace(19, 11, this, "getGraphicPanel", "Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    }
                    n = 0;
                }
                ++n5;
            }
            if (n != 0) {
                jdmLayout.setFracts(fArray);
            }
        } else {
            n2 = 1;
            jdmLayout.setScheme(n2);
        }
        GraphicContainer graphicContainer = new GraphicContainer();
        serializable = new GraphicHelp((BrowserApplet)this.lsBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)serializable);
        object2 = new Label("SLOT");
        ((Component)object2).setLocation(new Point(0, 45));
        graphicContainer.add((Component)object2);
        object = this.boxInfo.getLsModuleList();
        int n6 = this.boxInfo.getMaxNumOfSlots();
        n = 1;
        while (n < n6) {
            NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.lspeed.LsModulePanel", (RemoteModel)this.lsModule_model);
            string = new NavigationDestination("ibm.nways.lspeed.LsAtmModulePanel", (RemoteModel)this.lsAtmModule_model);
            Integer n7 = new Integer(n);
            if (((Hashtable)object).get(n7) != null) {
                StatusProxy statusProxy;
                Object object3;
                int n8 = (Integer)((Hashtable)object).get(n7);
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.Slot", n7);
                modelInfo.add("Index.SubSlot", new Integer(1));
                String string2 = null;
                try {
                    RemoteStatus remoteStatus;
                    if (n8 == 21) {
                        string2 = string;
                        remoteStatus = this.lsAtmModule_model.getStatusRefForRow(modelInfo);
                    } else {
                        string2 = navigationDestination;
                        remoteStatus = this.lsModule_model.getStatusRefForRow(modelInfo);
                    }
                    object3 = new LsModuleView(n7);
                    string2.setGraphicPanelProducer((GraphicPanelProducer)object3);
                    statusProxy = new StatusProxy(remoteStatus);
                }
                catch (Exception exception) {
                    RAS.logException(19, 11, this, "getGraphicPanel", exception);
                    statusProxy = null;
                }
                object3 = new NavigationContext();
                object3.setParent(this.lsBrowser.getNavigationTree().getNavContext());
                NavInitialRow.setInitialRow((NavigationContext)object3, (ModelInfo)modelInfo);
                GraphicImage graphicImage = new GraphicImage(this.lsBrowser.imageFrom((Object)this, LsBoxInfo.iconGifs[n8]), new Point(32, n3 += n4), 4, (GraphicAction)new GraphicActionNavigate((GraphicHandler)this.lsBrowser, (NavigationDestination)string2, object3), (Status)statusProxy);
                GraphicFlyOver graphicFlyOver = new GraphicFlyOver(String.valueOf(LsBoxInfo.ModuleDescr[n8]) + " Switching Module");
                graphicImage.setFlyOver(graphicFlyOver);
                graphicContainer.add((GraphicComponent)graphicImage);
                Label label = new Label(n7.toString(), 1);
                label.setLocation(new Point(0, n3 + 12));
                graphicContainer.add(label);
                Label label2 = new Label(LsBoxInfo.LsTypesExt[n8]);
                label2.setLocation(new Point(32, n3 + 40));
                graphicContainer.add(label2);
            }
            ++n;
        }
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.lsBrowser, (Component)graphicContainer);
        return graphicPanel;
    }
}

